clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default

%% Import data & Control panel
files = dir('*.mat');
h_case = 6; % 1:6
%% Plot Data
color_cell = {'b','k','r','g'};
legend_cell = {'Spiral','Step','Tapered','Slider'};

figure
hold on
for i = 1:length(files)
file_name = files(i).name;
load(file_name)
plot(Omega_rpm*1e-3,F_mat_opt(h_case,:),'Color',color_cell{i})
end
h = h_vec_opt(h_case);
xlabel('$\omega$ [$krpm$]')
ylabel('$W$ [$N$]')
title(['$h=$' num2str(h*1e6) ' $\mu m$'])
legend(legend_cell,'Location','northwest')
grid on




